package com.istock.test.service;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.istock.test.BusyLogger;

@Component
public class TestService {

	@Autowired
	private DataSource dataSource;
	
	private final String name_prefix = "dynamic_d1_";
	
	@Transactional
	@BusyLogger
	public int findCount() {
		String sql = "select count(1) from TB_DYNAMIC_INFO1 where name like :name";
		NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(dataSource);
		Map<String , Object> paramMap = new HashMap<String , Object>();
		paramMap.put("name","dynamic_%");
		return template.queryForInt(sql, paramMap);
	}
	
	@BusyLogger
	public String addRecord(String name) {
		String sql = "insert into TB_DYNAMIC_INFO1 (ID , NAME) VALUES(:id , :name)";
		NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(dataSource);
		Map<String , Object> paramMap = new HashMap<String , Object>();
		paramMap.put("id", UUID.randomUUID().toString());
		paramMap.put("name",name_prefix+name);
		template.update(sql, paramMap);
		return paramMap.get("id")+"";
	}
	
	@BusyLogger
	public void deleteRecord() {
		String sql = "delete from TB_DYNAMIC_INFO1 where name like :name";
		NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(dataSource);
		Map<String , Object> paramMap = new HashMap<String , Object>();
		paramMap.put("name","dynamic_%");
		template.update(sql, paramMap);
	}
}
