package com.istock.test;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerHandler implements MethodInterceptor{

	private Logger logger = LoggerFactory.getLogger(getClass());
	
	public Object invoke1(ProceedingJoinPoint pjp) throws Throwable {
		logger.info("=========================={}",pjp.getThis());
		return pjp.proceed();
	}

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		logger.info("=========================={}",invocation.getThis());
		return invocation.proceed();
	}
}
